// AcMapFlatOrclApiTestDescribeTableDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapFlatOrclApiTestDescribeTableDlg

#include "stdafx.h"
#include "AcMapFlatOrclApiTestDescribeTableDlg.h"
#include "AcMapFlatOrclApiTestTools.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestDescribeTableDlg dialog


//******************************************************************************************
AcMapFlatOrclApiTestDescribeTableDlg::AcMapFlatOrclApiTestDescribeTableDlg(
	const CString& strTableName,
	CWnd* pParent)
	: CDialog(AcMapFlatOrclApiTestDescribeTableDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(AcMapFlatOrclApiTestDescribeTableDlg)
	m_strTableDescription = _T("");
	m_strTableName = strTableName;
	//}}AFX_DATA_INIT
}


//******************************************************************************************
void AcMapFlatOrclApiTestDescribeTableDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapFlatOrclApiTestDescribeTableDlg)
	DDX_Control(pDX, IDC_EDIT_TABLE_NAME, m_editTableName);
	DDX_Control(pDX, IDC_EDIT_TABLE_DESCRIPTION, m_editTableDescription);
	DDX_Text(pDX, IDC_EDIT_TABLE_DESCRIPTION, m_strTableDescription);
	DDX_Text(pDX, IDC_EDIT_TABLE_NAME, m_strTableName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AcMapFlatOrclApiTestDescribeTableDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapFlatOrclApiTestDescribeTableDlg)
	ON_BN_CLICKED(IDC_BTN_DESCRIBE, OnBtnDescribe)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestDescribeTableDlg message handlers

//******************************************************************************************
BOOL AcMapFlatOrclApiTestDescribeTableDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_editTableDescription.SetTabStops(100);
	OnBtnDescribe();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//******************************************************************************************
bool AcMapFlatOrclApiTestDescribeTableDlg::FillDescription()
{
	std::vector<std::string> vectColumnNames;
	std::vector<std::string> vectDataTypes;

	bool bResult=AcMapFlatOrclApiTestTools::FillColumnNamesDataTypes(
		(const char*)m_strTableName,
		vectColumnNames,
		vectDataTypes,
		true);

	if (bResult)
	{
		m_strTableDescription="";
		for (int i=0; i<vectColumnNames.size(); i++)
		{
			m_strTableDescription+=vectColumnNames[i].c_str();
			m_strTableDescription+="\t";
			m_strTableDescription+=vectDataTypes[i].c_str();
			m_strTableDescription+="\r\n";
		}
	}

	return bResult;
}

//******************************************************************************************
void AcMapFlatOrclApiTestDescribeTableDlg::OnBtnDescribe() 
{
	UpdateData(true);
	if (!m_strTableName.IsEmpty())
	{
		if (!FillDescription())
		{
			AfxMessageBox("Could not describe the table");
			return;
		}
	}
	UpdateData(false);
}

